/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.serialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.pojo.animation.bedrock.AnimationKeyframes;
import it.unimi.dsi.fastutil.doubles.Double2ObjectRBTreeMap;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.joml.Vector3f;

public class AnimationKeyframesSerializer
implements JsonDeserializer<AnimationKeyframes> {
    public AnimationKeyframes deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Double2ObjectRBTreeMap keyframes = new Double2ObjectRBTreeMap();
        if (json.isJsonPrimitive()) {
            if (json.getAsJsonPrimitive().isString()) {
                GunMod.LOGGER.debug("Molang is not supported: \"{}\"", (Object)json.getAsString());
                return new AnimationKeyframes((Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe>)keyframes);
            }
            float value = json.getAsJsonPrimitive().getAsFloat();
            Vector3f data = new Vector3f(value, value, value);
            AnimationKeyframes.Keyframe keyframe = new AnimationKeyframes.Keyframe(null, null, data, null);
            keyframes.put(0.0, (Object)keyframe);
            return new AnimationKeyframes((Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe>)keyframes);
        }
        if (json.isJsonArray()) {
            Vector3f data = this.readVector3f(json.getAsJsonArray());
            AnimationKeyframes.Keyframe keyframe = new AnimationKeyframes.Keyframe(null, null, data, null);
            keyframes.put(0.0, (Object)keyframe);
            return new AnimationKeyframes((Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe>)keyframes);
        }
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            for (Map.Entry entrySet : jsonObject.entrySet()) {
                double time;
                try {
                    time = Double.parseDouble((String)entrySet.getKey());
                }
                catch (NumberFormatException e) {
                    GunMod.LOGGER.debug("Molang is not supported: \"{}\"", entrySet.getKey());
                    return new AnimationKeyframes((Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe>)keyframes);
                }
                AnimationKeyframes.Keyframe keyframe = this.readKeyFrames((JsonElement)entrySet.getValue());
                keyframes.put(time, (Object)keyframe);
            }
            return new AnimationKeyframes((Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe>)keyframes);
        }
        return new AnimationKeyframes((Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe>)keyframes);
    }

    private AnimationKeyframes.Keyframe readKeyFrames(JsonElement element) {
        if (element.isJsonArray()) {
            Vector3f data = this.readVector3f(element.getAsJsonArray());
            return new AnimationKeyframes.Keyframe(null, null, data, null);
        }
        if (element.isJsonObject()) {
            JsonArray array;
            JsonObject jsonObject = element.getAsJsonObject();
            String lerpMode = null;
            Vector3f pre = null;
            Vector3f post = null;
            if (jsonObject.has("lerp_mode")) {
                lerpMode = jsonObject.get("lerp_mode").getAsString();
            }
            if (jsonObject.has("pre") && jsonObject.get("pre").isJsonArray()) {
                array = jsonObject.get("pre").getAsJsonArray();
                pre = this.readVector3f(array);
            }
            if (jsonObject.has("post") && jsonObject.get("post").isJsonArray()) {
                array = jsonObject.get("post").getAsJsonArray();
                post = this.readVector3f(array);
            }
            return new AnimationKeyframes.Keyframe(pre, post, null, lerpMode);
        }
        return new AnimationKeyframes.Keyframe(null, null, null, null);
    }

    private Vector3f readVector3f(JsonArray array) {
        JsonElement xElement = array.get(0);
        JsonElement yElement = array.get(1);
        JsonElement zElement = array.get(2);
        float x = this.readVector3fElement(xElement, "(array i=0)");
        float y = this.readVector3fElement(yElement, "(array i=1)");
        float z = this.readVector3fElement(zElement, "(array i=2)");
        return new Vector3f(x, y, z);
    }

    private float readVector3fElement(JsonElement element, String memberName) {
        if (element.getAsJsonPrimitive().isString()) {
            GunMod.LOGGER.debug("Molang is not supported: \"{}\"", (Object)element.getAsString());
            return 0.0f;
        }
        return GsonHelper.m_13888_((JsonElement)element, (String)memberName);
    }
}

